%define module_name DT
# BEGIN SourceDeps(oneline):
BuildRequires: perl(DateTime/Duration.pm) perl(DateTime/Format/ISO8601.pm) perl(DateTime/Format/ISO8601/Format.pm) perl(DateTime/Moonpig.pm) perl(ExtUtils/MakeMaker.pm) perl(Scalar/Util.pm) perl(Sub/Install.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.5.0
Release: alt1
Summary: DWIM wrapper for DateTime
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/N/NO/NOHUHU/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
=for readme continue

DT is a very simple and thin wrapper over DateTime::Moonpig, which
in turn is a wrapper over DateTime. DateTime::Moonpig brings immutability
and saner operator overloading at the cost of cartoonish name but also
lacks date/time parsing capabilities that are badly needed all the time.

There is a myriad of helpful modules on CPAN but oh all that typing!

Consider:

    use DateTime;
    my $dt = DateTime->from_epoch(epoch => time);

    use DateTime::Format::Pg;
    my $dt = DateTime::Format::Pg->parse_datetime($timestamp_from_postgres);

    use DateTime::Format::ISO8601;
    my $dt = DateTime::Format::ISO8601->parse_datetime($iso_datetime);

Versus:

    use DT ':pg';
    my $dt_unix = DT->new(time);
    my $dt_pg = DT->new($timestamp_from_postgres);
    my $dt_iso = DT->new($iso_datetime);

DT constructor will try to Do What You Mean, and if it cannot it will
fall back to default DateTime constructor. Simple.

=for readme stop

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README
%perl_vendor_privlib/D*

%changelog
