# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Fcntl.pm) perl(UNIVERSAL.pm) perl(URI/file.pm) perl(overload.pm) perl(AnyDBM_File.pm)
# END SourceDeps(oneline)
%define module_version 0.24
%define module_name DWH_File
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.24
Release: alt1
Summary: data and object persistence in deep and wide hashes
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/S/SU/SUMUS/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
Note: the files produced by DWH_File 0.22 are in a different format.and are incompatible with the files produced by previous versions.

DWH_File is used in a manner resembling NDBM_File, DB_File etc. These
DBM modules are limited to storing flat scalar values. References to data
such as arrays or hashes are stored as useless strings and the data in the
referenced structures will be lost.

DWH_File uses one of the DBM modules (configurable through the parameters
to `use()'), but extends the functionality to not only save referenced data
structures but even object systems.

This is why I made it. It makes it extremely simple to achieve persistence in
object oriented Perl programs and you can skip the cumbersome interaction with
a conventional database.

DWH_File tries to make the tied hash behave as much like a standard Perl hash
as possible. Besides the capability to store nested data structures DWH_File
also implements `exists()', `delete()' and `undef()' functionality like
that of a standard hash (as opposed to all the DBM modules).


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README
%perl_vendor_privlib/D*

%changelog
