%define module_version 1.00
%define module_name Dancer-Plugin-Auth-Extensible
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Authen/Simple/PAM.pm) perl(Crypt/SaltedHash.pm) perl(Dancer.pm) perl(Dancer/Plugin/Database.pm) perl(ExtUtils/MakeMaker.pm) perl(Test/More.pm) perl(Unix/Passwd/File.pm) perl(YAML.pm) perl(base.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.00
Release: alt1
Summary: extensible authentication framework for Dancer apps
Group: Development/Perl
License: perl
URL: https://github.com/bigpresh/Dancer-Plugin-Auth-Extensible/

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/B/BI/BIGPRESH/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
A user authentication and authorisation framework plugin for Dancer apps.

Makes it easy to require a user to be logged in to access certain routes,
provides role-based access control, and supports various authentication
methods/sources (config file, database, Unix system users, etc).

Designed to support multiple authentication realms and to be as extensible as
possible, and to make secure password handling easy (the base class for auth
providers makes handling `RFC2307'-style hashed passwords really simple, so you
have no excuse for storing plain-text passwords).

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %{?epoch:%epoch:}%version-%release

%description scripts
scripts for %module_name



%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README example
%perl_vendor_privlib/D*

%files scripts
%_bindir/*

%changelog
