# BEGIN SourceDeps(oneline):
BuildRequires: perl(DBD/SQLite.pm) perl(Dancer.pm) perl(Dancer/Config.pm) perl(Dancer/Plugin.pm) perl(Dancer/Plugin/Database.pm) perl(Dancer/Test.pm) perl(ExtUtils/MakeMaker.pm) perl(List/Util.pm) perl(Test/More.pm) perl(Time/Piece.pm)
# END SourceDeps(oneline)
%define module_version 0.04
%define module_name Dancer-Plugin-Log-DB
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.04
Release: alt1
Summary: log arbitrary messages into a database from within your Dancer application.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/N/NA/NAVI/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
Provides an easy way to add arbitrary logging messages into a database for your Dancer application.
Supports more than one common field ('message') to add bits of information into.

You can add as many fields as you wish in your database table and fill them in with *log_db* calls.

Default fields are *message* and *timestamp*, thus at its simplest case it requires database table with the following SQL declaration:

=over 4

=item * *id* field.

Or any name you want - the plugin doesn't care of this field at all. Autoincrementing for this field would be a good choice.

=item * *message* field.

This is where message will be stored. TEXT/VARCHAR type.

=item * *timestamp* field.

Where timestamp field will be kept. TIMESTAMP/TEXT/VARCHAR type.

=back

You can expand functionality by adding any number of columns and write any data supported by your database backend.

For example, in complement to existing *timestamp* and *message* fields you can also add *server_id* column to store server id which left the message.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/D*

%changelog
