%define module_name Dancer-Plugin-Thumbnail
# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Dancer.pm) perl(ExtUtils/CBuilder.pm) perl(ExtUtils/MakeMaker.pm) perl(GD.pm) perl(Image/Size.pm) perl(JSON.pm) perl(JSON/MaybeXS.pm) perl(LWP/Simple.pm) perl(List/Util.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(Object/Signature.pm) perl(POSIX.pm) perl(Parse/CPAN/Meta.pm) perl(Test/More.pm) perl(YAML/Tiny.pm) perl(lib/abs.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.16
Release: alt1
Summary: Easy thumbnails creating with Dancer and GD
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/L/LO/LONERR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
use Dancer;
 use Dancer::Plugin::Thumbnail;

 # simple resize
 get '/resized/:width/:image' => sub {
     resize param('image') => { w => param 'width' };
 }

 # simple crop
 get '/cropped/:width/:image' => sub {
     crop param('image') => { w => param 'width' };
 }

 # more complex
 get '/thumb/:w/:h/:image' => sub {
     thumbnail param('image') => [
         crop   => { w => 200, h => 200, a => 'lt' },
         resize => { w => param('w'), h => param('h'), s => 'min' },
     ], { format => 'jpeg', quality => 90 };
 }



%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/D*

%changelog
