# BEGIN SourceDeps(oneline):
BuildRequires: perl(Dancer2/Plugin/HTTP/Caching.pm) perl(Dancer2/Plugin/HTTP/ConditionalRequest.pm) perl(Dancer2/Plugin/HTTP/ContentNegotiation.pm) perl(ExtUtils/MakeMaker.pm) perl(Import/Into.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_version 0.02
%define module_name Dancer2-Plugin-HTTP-Bundle
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.02
Release: alt1
Summary: The missing HTTP bits of Dancer2 Bundled
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/V/VA/VANHOESEL/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
There are a few Dancer2 Plugins to help building REST api's. This wrapper helps
loading them all at once, in the right order and will demonstrate the combined
use of them.

    use Dancer2::Plugin::HTTP::Bundle
    
    get '/secrets/:id' => http_auth_handler_can('find_something') => sub {
        my $secret_object = http_auth_handler->find_something(param->{id})
            or return sub { status (404 ) };
        http_conditional (
            etag            => $secret_object->etag,
            last_modified   => $secret_object->date_last_modified
        ) =>sub { http_choose_accept (
            'application/json' => sub { to_json $secret_object },
            'application/xml'  => sub { to_xml  $secret_object },
            { default => undef }
        ) }
    };

Or a little more verbose

    use Dancer2::Plugin::HTTP:::Bundle
    
    get '/secrets/:id' => http_auth_handler_can('find_something') => sub {
        
        # what content-type does the client want
        http_choose_accept (
            
            [ 'application/json', 'application/xml' ] => sub {
                    
                # find the resource
                
                my $secret_object =
                    http_auth_handler->find_something(param->{id});
                
                unless ( $secret_object ) {
                    status (404); # Not Found
                    return;
                }
                
                # set caching information
                
                http_cache_max_age 3600;
                http_cache_private;
                
                # make the request conditional
                # maybe we do not need to serialize
                
                http_conditional (
                    etag            => $secret_object->etag,
                    last_modified   => $secret_object->date_last_modified
                ) => sub {
                    for (http_accept) {
                        when ('application/json') {
                            return to_json ( ...
%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes examples
%perl_vendor_privlib/D*

%changelog
