# BEGIN SourceDeps(oneline):
BuildRequires: perl(Dancer2/Plugin.pm) perl(ExtUtils/MakeMaker.pm) perl(HTTP/Date.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_version 0.01
%define module_name Dancer2-Plugin-HTTP-Caching
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.01
Release: alt1
Summary: RFC 7234 compliant
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/V/VA/VANHOESEL/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
Setting the HTTP response headers 'Expire' and 'Cache-Control' according to
RFC 7234

    
    use Dancer2;
    use Dancer2::Plugin::HTTP::Caching;
    
    get '/aging' => sub {
        http_cache_max_age          3600; # one hour
        http_cache_private;
        http_cache_must_revalidate;
        http_cache_no_cache         'Set-Cookie';
        http_cache_no_cache         'WWW-Authenticate';
        http_expire                 'Thu, 31 Dec 2015 23:23:59 GMT';
        
        "This content must be refreshed within 1 Hour\"
    };
%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes README.md examples
%perl_vendor_privlib/D*

%changelog
