%define module_version 0.05
%define module_name Dancer2-Plugin-HTTP-ConditionalRequest
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Dancer2/Plugin.pm) perl(DateTime.pm) perl(DateTime/Format/HTTP.pm) perl(ExtUtils/MakeMaker.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.05
Release: alt1
Summary: RFC 7232 compliant
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/V/VA/VANHOESEL/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
Conditionally handling HTTP request based on eTag or Modification-Date,
according to RFC 7232

HTTP Conditional Requests are used for telling servers that they only have to
perform the method if the preconditions are met. Such requests are either used
by caches to (re)validate the cached response with the origin server - or -
to prevent lost-updates with unsafe-methods in a stateless api (like REST).
 
    any '/my_resource/:id' => sub {
        ...
        # check stuff
        # - compute eTag from MD5
        # - use an external table
        # - find a last modification date
        ...
        
        http_conditional {
            etag            => '2d5730a4c92b1061',
            last_modified   => "Tue, 15 Nov 1994 12:45:26 GMT", # HTTP Date
            required        => false,
        } => sub {
            ...
            # do the real stuff, like updating
            ...
        }
    };
%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes README.md examples
%perl_vendor_privlib/D*

%changelog
