%define module_name Dancer2-Plugin-OpenAPIRoutes
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Dancer2.pm) perl(Data/Walk.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(JSON.pm) perl(JSON/Pointer.pm) perl(Module/Load.pm) perl(Path/Tiny.pm) perl(Test/Most.pm) perl(YAML/XS.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.03
Release: alt1
Summary: automatic routes creation
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/A/AN/ANTONPETR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Automatically creates Dancer's routes from Swagger specification file.
Extracts request parameters according to given spec. Uploaded files are  
the Dancer2::Core::Request::Upload manpage objects.

Automatically decodes JSON parameters if "Content-Type" is application/json.
Automatically encodes answers to application/json if "Accept" header asks for
it and returned value is reference. It checks also whether parameter is 
required or not but doesn't do real validation yet.

Catches thrown exceptions and makes JSON error messages if "Accept" 
is application/json. 

Makes very smart mapping from route to Module::handler_function.
For example:

  /order:
    post:
    ...
  /order/{id}
    delete:
    ...
    patch:
    ...

will be mapped to Order::create(), Order::remove() and Order::update() 
accordingly.
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md
%perl_vendor_privlib/D*

%changelog
