# BEGIN SourceDeps(oneline):
BuildRequires: perl(Dancer2.pm) perl(Dancer2/Plugin/RootURIFor.pm) perl(ExtUtils/MakeMaker.pm) perl(HTTP/Request/Common.pm) perl(Plack/Builder.pm) perl(Plack/Test.pm) perl(Pod/Coverage/TrustPod.pm) perl(Pod/Usage.pm) perl(Ref/Util.pm) perl(Test/CheckManifest.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(Test/Requires.pm) perl(base.pm)
# END SourceDeps(oneline)
%define module_name Dancer2-Plugin-Routing
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.01
Release: alt1
Summary: A dancer2 plugin for configurable routing.
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/MZ/MZIESCHA/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Configuration:

    plugins:
        Routing:
            template_key: routing
            routes:
                main:
                  route: '/'
                  package: MyApp
                api:
                  route: '/api'
                  package: MyApp::API
                moderation:
                  route: '/mod'
                  package: MyApp::Moderation
                admin: '/~admin'
                assets:
                  route: '/assets'
                  package:  MyApp::Assets
Code:

    use Dancer2;
    use Dancer2::Plugin::Routing;
    use Plack::Builder;
    use MyApp;
    ...
    builder {
        mount routing_for('main')       => MyApp->to_app             if mount routing_for('main');
        mount routing_for('api')        => MyApp::API->to_app        if mount routing_for('api');
        mount routing_for('moderation') => MyApp::Moderation->to_app if mount routing_for('moderation');
        mount routing_for('admin')      => MyApp::Admin->to_app      if mount routing_for('admin');
        mount routing_for('assets')     => MyApp::Assets->to_app     if mount routing_for('assets');
    };

    ...

    use Dancer2;
    use Dancer2::Plugin::Routing;

    get '/do/stuff' => sub {
        return root_redirect '/';
    };

Template:

    <a href="[%% routing.admin %%]/page">To some admin page</a>
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README.md LICENSE
%perl_vendor_privlib/D*

%changelog
