%define module_name Dash
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Alt/Data/Frame/ButMore.pm) perl(Browser/Open.pm) perl(Const/Fast.pm) perl(Data/Dump.pm) perl(Data/Frame.pm) perl(Exporter/Auto.pm) perl(File/ShareDir.pm) perl(IO/All.pm) perl(JSON.pm) perl(Module/Build.pm) perl(Module/Load.pm) perl(Mojo/Base.pm) perl(Mojolicious.pm) perl(Moo.pm) perl(PDL.pm) perl(PDL/Primitive.pm) perl(Path/Tiny.pm) perl(Scalar/Util.pm) perl(Test/Mojo.pm) perl(Test/More.pm) perl(Test/Most.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Synopsis.pm) perl(Text/CSV.pm) perl(Text/Template.pm) perl(Throwable.pm) perl(Try/Tiny.pm) perl(aliased.pm) perl(namespace/clean.pm) perl(overload.pm) perl(strict.pm) perl(strictures.pm) perl(utf8.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.11
Release: alt1
Summary: Analytical Web Apps in Perl (Port of Plotly's Dash to Perl)
Group: Development/Perl
License: mit
URL: https://github.com/pablrod/perl-Dash

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PA/PABLROD/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This package is a port of Plotly's Dash to Perl. As
the official Dash doc says: *Dash is a productive Python framework for building web applications*. 
So this Perl package is a humble atempt to ease the task of building data visualization web apps in Perl.

The ultimate goal of course is to support everything that the Python version supports.

The use will follow, as close as possible, the Python version of Dash so the Python doc can be used with
minor changes:

=over 4

=item Use of -> (arrow operator) instead of .

=item Main package and class for apps is Dash

=item Component suites will use Perl package convention, I mean: dash_html_components will be Dash::Html::Components, although for new component suites you could use whatever package name you like

=item Instead of decorators we'll use plain old callbacks

=item Instead of Flask we'll be using the Mojolicious manpage (Maybe in the future the Dancer2 manpage)

=back

In the SYNOPSIS you can get a taste of how this works and also in the examples folder of the distribution or directly in repository

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README Changes CONTRIBUTING.md examples
%perl_vendor_privlib/D*
%perl_vendor_privlib/auto/*

%changelog
