%define module_name Data-BiaB
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Data/Hexify.pm) perl(ExtUtils/MakeMaker.pm) perl(MIDI.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.11
Release: alt1
Summary: Analyze Band-in-a-Box data files
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/J/JV/JV/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module provides methods to read Band-in-a-Box data files and
extract some useful information from them.

Band-in-a-Box is an excellent tool for creating professional music and
accompanying tracks. I've been using it for many years but had to
abandon it when I phased out Microsoft Windows PCs.

Example:

    use Data::BiaB;

    # Load an existing song.
    my $biab = Data::BiaB->new();
    $biab->load("Vaya_Con_Dios.mgu");

    # This will show what was gathered.
    use Data::Dumper;
    print Dumper($biab);
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes examples
%perl_vendor_privlib/D*

%changelog
