# BEGIN SourceDeps(oneline):
BuildRequires: perl(Encode.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(Scalar/Util.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(constant.pm) perl(overload.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define module_name Data-Bool
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 2.98014
Release: alt1
Summary: An interface to booleans as objects for Perl
Group: Development/Perl
License: perl
URL: https://github.com/aferreira/cpan-Data-Bool

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/F/FE/FERREIRA/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Perl has no native representation for booleans.
Most of the time the Perl concept of truth is enough.
But when dealing with serialization of formats
which support booleans, it is desirable to keep the
booleans intact on round trips, eg. when writing after loading.
And there are other good reasons for that,
like strict validation via various mechanisms, like schemas,
OpenAPI, type hierarchies, etc.

A solution for that was adopted for JSON modules
around 2012 by using references to `1' or `0'
blessed into the JSON::PP::Boolean manpage which was chosen
as the canonical package for these objects.

The problem with that was the coupling with the JSON::PP manpage
for no apparent good reason. Booleans are independent
of JSON and this association makes little sense
when loading documents in formats like YAML, MessagePack, BSON, etc.
However, the integration of the concept of boolean
for all these applications is quite convenient.

Marc Lehmann's the Types::Serialiser manpage approached this problem
by creating a common interface used by the JSON::XS manpage and the CBOR::XS manpage
modules. This module lifts this core concept (including
idea, implementation and documentation) into an isolated treatment
for booleans only .e' so this may work as a common
ground for interoperability on booleans as objects for Perl modules.

The implementation keeps the compatibility with the
previous agreement on `JSON::PP::Boolean' by making
the `Data::Bool' implementation stash an alias for
`JSON::PP::Boolean'.

That means

    Data::Bool::true->isa('JSON::PP::Boolean');

but also

    Data::Bool::true->isa(Data::Bool::BOOL_PACKAGE);

This also allows the optimization of an isa test
to a direct comparison of stash pointers. That is,

    ref Data::Bool::true eq Data::Bool::BOOL_PACKAGE

is equivalent to

    ref Data::Bool::true eq 'JSON::PP::Boolean'

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes README
%perl_vendor_privlib/D*

%changelog
