# BEGIN SourceDeps(oneline):
BuildRequires: perl(Config.pm) perl(Data/ShowTable.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(IO/File.pm) perl(LWP/Simple.pm) perl(Storable.pm) perl(Test.pm)
# END SourceDeps(oneline)
%define module_version 1.01
%define module_name Data-CTable
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.01
Release: alt1
Summary: Read, write, manipulate tabular data
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/C/CH/CHTHORMAN/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
## Read some data files in various tabular formats.	use          Data::CTable;
	my $People = Data::CTable->new("people.merge.mac.txt");
	my $Stats  = Data::CTable->new("stats.tabs.unix.txt");

	## Clean stray whitespace in fields
	$People->clean_ws();
	$Stats ->clean_ws();

	## Retrieve columns
	my $First = $People->col('FirstName');  
	my $Last  = $People->col('LastName' );

	## Calculate a new column based on two others
	my $Full  = [map {"$First->[$_] $Last->[$_]"} @{$People->all()}];

	## Add new column to the table
	$People->col(FullName => $Full);

	## Another way to calculate a new column
	$People->col('Key');
	$People->calc(sub {no strict 'vars'; $Key = "$Last,$First";});

	## "Left join" records matching Stats:PersonID to People:Key
	$Stats->join($People, PersonID => 'Key');

	## Find certain records
	$Stats->select_all();
	$Stats->select(Department => sub {/Sale/i  });  ## Sales depts
	$Stats->omit  (Department => sub {/Resale/i});  ## not Resales
	$Stats->select(UsageIndex => sub {$_ > 20.0});  ## high usage

	## Sort the found records
	$Stats->sortspec('DeptNum'   , {SortType => 'Integer'});
	$Stats->sortspec('UsageIndex', {SortType => 'Number' });
	$Stats->sort([qw(DeptNum UsageIndex Last First)]);

	## Make copy of table with only found/sorted data, in order
	my $Report = $Stats->snapshot();

	## Write an output file
	$Report->write(_FileName => "Rept.txt", _LineEnding => "mac");

	## Print a final progress message.
	$Stats->progress("Done!");

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %{?epoch:%epoch:}%name = %version-%release

%description scripts
scripts for %module_name

	## Dozens more methods and parameters available...


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build INSTALLMAN1DIR=%_man1dir

%install
%perl_vendor_install

%files
%doc Changes.txt README
%perl_vendor_privlib/D*

%files scripts
%_bindir/*
%_man1dir/*
%changelog
