%define module_name Data-Clean
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Clone/PP.pm) perl(Data/Dmp.pm) perl(DateTime.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Log/ger.pm) perl(Pod/Coverage/TrustPod.pm) perl(Scalar/Util.pm) perl(String/LineNumber.pm) perl(String/PerlQuote.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.508
Release: alt1
Summary: Clean data structure
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Data-Clean

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PE/PERLANCAR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This class can be used to process a data structure by replacing some forms of
data items with other forms. One of the main uses is to clean "unsafe" data,
e.g. clean a data structure so it can be encoded to JSON (see
the Data::Clean::JSON manpage, which is a thin wrapper over this class).

As can be seen from the example, you specify a list of transformations to be
done, and then this class will generate an appropriate Perl code to do the
cleansing. This class is faster than the other ways of processing, e.g.
the Data::Rmap manpage (see the Bencher::Scenarios::DataCleansing manpage for some benchmarks).

=for Pod::Coverage ^(command_.+)$
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README LICENSE
%perl_vendor_privlib/D*

%changelog
