%define module_name Data-Clean-ForJSON
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Clone/PP.pm) perl(Data/Clean.pm) perl(DateTime.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(JSON/PP.pm) perl(Pod/Coverage/TrustPod.pm) perl(Scalar/Util.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(Test/Needs.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(parent.pm) perl(strict.pm) perl(vars.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.395
Release: alt1
Summary: Clean data so it is safe to output to JSON
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Data-Clean-ForJSON

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PE/PERLANCAR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This class cleans data from anything that might be problematic when encoding to
JSON. This includes coderefs, globs, and so on. Here's what it will do by
default:

=over

=item * Change DateTime and Time::Moment object to its epoch value

=item * Change Regexp and version object to its string value

=item * Change scalar references (e.g. \1) to its scalar value (e.g. 1)

=item * Change other references (non-hash, non-array) to its ref() value (e.g. "GLOB", "CODE")

=item * Clone circular references

With a default limit of 1, meaning that if a reference is first seen again for
the first time, it will be cloned. But if it is seen again for the second time,
it will be replaced with "CIRCULAR".

To change the default limit, customize your cleanser object:

 $cleanser = Data::Clean::ForJSON->new(
     -circular => ["clone", 4],
 );

or you can perform other action for circular references, see the Data::Clean manpage for
more details.

=item * Unbless other types of objects

=back

Cleaning recurses into objects.

Data that has been cleaned will probably not be convertible back to the
original, due to information loss (for example, coderefs converted to string
`"CODE"').

The design goals are good performance, good defaults, and just enough
flexibility. The original use-case is for returning JSON response in HTTP API
service.

This module is significantly faster than modules like the Data::Rmap manpage or
the Data::Visitor::Callback manpage because with something like Data::Rmap you repeatedly
invoke callback for each data item. This module, on the other hand, generates a
cleanser code using eval(), using native Perl for() loops.

If `LOG_CLEANSER_CODE' environment is set to true, the generated cleanser code
will be logged using the Log::get manpage at trace level. You can see it, e.g. using
the Log::ger::Output::Screen manpage:

 %% LOG_CLEANSER_CODE=1 perl -MLog::ger::Output=Screen -MLog::ger::Level::trace -MData::Clean::ForJSON \
   -e'$c=Data::Clean::ForJSON->new; ...'

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README Changes
%perl_vendor_privlib/D*

%changelog
