%define module_name Data-Cmp
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Pod/Coverage/TrustPod.pm) perl(Scalar/Util.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.010
Release: alt1
Summary: Compare two data structures, return -1/0/1 like cmp
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Data-Cmp

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PE/PERLANCAR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module offers the `cmp_data' function that can compare two data structures
in a flexible manner. The function can return a ternary value -1/0/1 like Perl's
`cmp' or `<=>' operator (or another value 2, if the two data structures
differ but there is no sensible notion of which one is larger than the other).

This module can handle circular structure.

This module offers an alternative to the Test::Deep manpage (specifically,
the Test::Deep::NoDeep manpage's `is_deeply()'). Test::Deep allows customizing
comparison on specific points in a data structure, while Data::Cmp's
`cmp_data()' is more geared towards customizing comparison behavior across all
points in a data structure. Depending your needs, one might be more convenient
than the other.

For basic customization, you can turn on case-sensitive matching or numeric
tolerance. For more advanced customization, you can provide coderefs to perform
comparison of data items yourself.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes LICENSE
%perl_vendor_privlib/D*

%changelog
