# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Carp.pm) perl(Exporter.pm) perl(ExtUtils/CBuilder.pm) perl(ExtUtils/MakeMaker.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(Parse/CPAN/Meta.pm) perl(Pod/Coverage.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(YAML/Tiny.pm)
# END SourceDeps(oneline)
%define module_name Data-DPath-Flatten
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.00
Release: alt1
Summary: Convert complex data structure into key/value pairs
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/R/RB/RBWOHLFAR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Data::DPath::Flatten transforms an arbitrary data structure into a hash of
key/value pairs. 

Why? To store raw data in an SQL database. the ETL::Pipeline::Input manpage returns 
arbitrary data structures. For example, Excel files return an array but XML 
files a hash. Data::DPath::Flatten gives me a unique key for each field in
the file, regardless of the Perl data structure.

Use Data::DPath::Flatten where you need key/value pairs from arbitrary data.
The module traverses nested data structures of any depth and converts into a 
single dimension.


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE.md CONTRIBUTING.md README.md
%perl_vendor_privlib/D*

%changelog
