%define module_name Data-Dumper-Interp
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Capture/Tiny.pm) perl(Carp.pm) perl(Carp/Always.pm) perl(Clone.pm) perl(Cwd.pm) perl(Data/Compare.pm) perl(Data/Dumper.pm) perl(Data/Structure/Util.pm) perl(Data/Visitor.pm) perl(Encode.pm) perl(Encode/CN.pm) perl(Encode/JP.pm) perl(Encode/KR.pm) perl(Encode/TW.pm) perl(English.pm) perl(Env.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Basename.pm) perl(File/Path.pm) perl(File/Spec.pm) perl(File/Spec/Functions.pm) perl(File/Temp.pm) perl(FindBin.pm) perl(Getopt/Long.pm) perl(Guard.pm) perl(Import/Into.pm) perl(JSON.pm) perl(List/Util.pm) perl(Math/BigFloat.pm) perl(Math/BigInt.pm) perl(Math/BigRat.pm) perl(Moose.pm) perl(POSIX.pm) perl(Path/Tiny.pm) perl(Pod/Coverage/TrustPod.pm) perl(Regexp/Common.pm) perl(Scalar/Util.pm) perl(Sub/Identify.pm) perl(Term/ReadKey.pm) perl(Test/Pod.pm)
BuildRequires: perl(Test/Pod/Coverage.pm) perl(Test2/Plugin/BailOnFail.pm) perl(Test2/V0.pm) perl(Tie/Array.pm) perl(Tie/Handle.pm) perl(Tie/Hash.pm) perl(Tie/Scalar.pm) perl(Time/HiRes.pm) perl(autovivification.pm) perl(bigint.pm) perl(bignum.pm) perl(bigrat.pm) perl(constant.pm) perl(feature.pm) perl(if.pm) perl(indirect.pm) perl(lib.pm) perl(multidimensional.pm) perl(overload.pm) perl(parent.pm) perl(strict.pm) perl(utf8.pm) perl(vars.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 7.013
Release: alt1
Summary: Data::Dumper for humans, with interpolation
Group: Development/Perl
License: unrestricted
URL: https://github.com/jimav/Data-Dumper-Interp

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/J/JI/JIMAVERA/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This is a wrapper for Data::Dumper optimized for consumption by humans
instead of machines; the output defaults to higher-level 
forms which may not be 'eval'able.

The namesake feature is interpolating Data::Dumper output 
into strings, but simple functions are also provided to 
visualize a scalar, array, or hash.

Diagnostic and debug messages are primary use cases.

Internally, Data::Dumper is called to visualize (i.e. format) data
with pre- and postprocessing to "improve" the results:

Output is compact (1 line if possibe,
otherwise folded at your terminal width), and OMITS a trailing newline.
Unicode characters appear as themselves,
objects like Math:BigInt are stringified, "virtual" values behind
overloaded array/hash-deref operators are shown, and 
some Data::Dumper bugs^H^H^H^Hquirks are circumvented.
See "DIFFERENCES FROM Data::Dumper".

Finally, a few utilities are provided to quote strings for /bin/sh.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README LICENSE README_how_to_report_bugs Changes
%perl_vendor_privlib/D*

%changelog
