# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Test/More.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define module_name Data-Dumper-UnDumper
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.02
Release: alt1
Summary: load Data::Dumper output, including self-references
Group: Development/Perl
License: perl
URL: https://github.com/bigpresh/Data-Dumper-UnDumper

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/B/BI/BIGPRESH/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Firstly, a safety warning: loading the Data::Dumper manpage output, which is designed
to be `eval'ed, is a big safety risk if the data comes from an untrusted
source.  It's evaled as Perl code, so it can do anything you could write a
Perl program to.  Future versions of this module may use the Safe manpage to mitigate
that risk somewhat, but it's still there - to support object references,
`bless' would have to be allowed.

So, given the choice, what should you use instead?  Any of the many serialisation
options that don't serialise as code - for e.g. JSON, YAML, etc.

I wrote this module, though, because I didn't have a choice - I was receiving
the Data::Dumper manpage output which had been written to a log in the past by some code,
without using the `<$Data::Dumper::PURITY'> setting, so it included `$VAR1'
references, including re-used the JSON::PP manpage objects.

This has been lightly tested with the default output from `Data::Dumper::Dump()'.
It's quite likely that you could have the Data::Dumper manpage generate output this will
not handle by setting some of the dumping options.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes LICENSE
%perl_vendor_privlib/D*

%changelog
