%define module_name Data-Enumerable-Lazy
# BEGIN SourceDeps(oneline):
BuildRequires: perl(List/Util.pm) perl(Test/Exception.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.032
Release: alt1
Summary: >new({
Group: Development/Perl
License: perl
URL: https://github.com/icanhazbroccoli/Data-Enumerable-Lazy

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/O/OL/OLEGS/Perl-%{module_name}/Data-Enumerable-Lazy-%{version}.tar.gz
BuildArch: noarch

%description
This library is another one implementation of a lazy generator + enumerable
for Perl5. It might be handy if the elements of the collection are resolved on
the flight and the iteration itself should be hidden from the end users.

The enumerables are single-pass composable calculation units. What it means:
An enumerable is stateful, once it reached the end of the sequence, it will
not rewind to the beginning unless explicitly forced to.
Enumerables are composable: one enumerable might be an extension of another by
applying some additional logic. Enumerables resolve steps on demand, one by one.
A single step might return another enumerable (micro batches). The library
flattens these enumerables, so for the end user this looks like a single
continuous sequence of elements.


  [enumerable.has_next] -> [_buffer.has_next] -> yes -> return true
                                              -> no -> result = [enumerable.on_has_next] -> return result

  [enumerable.next] -> [_buffer.has_next] -> yes -> return [_buffer.next]
                                          -> no -> result = [enumerable.next] -> [enumerable.set_buffer(result)] -> return result

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/D*

%changelog
