%define module_name Data-Fake
%define _without_test 1
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(Import/Into.pm) perl(List/Util.pm) perl(Test/Deep.pm) perl(Test/More.pm) perl(Text/Lorem.pm) perl(Time/Piece.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.006
Release: alt1
Summary: Declaratively generate fake structured data for testing
Group: Development/Perl
License: apache
URL: https://github.com/dagolden/Data-Fake

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/D/DA/DAGOLDEN/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module generates randomized, fake structured data using declarative
syntax.

`Data::Fake' is built on higher-order programming principles.  It provides
users with "factory" functions, which create "generator" functions for
specific pieces of data.

Wherever randomized, fake data is desired, a generator code reference is
used as a placeholder for the desired output.  Each time the top-level
generator is run, nested generators are recursively run to turn
placeholders into the desired randomized data.

For example, the SYNOPSIS declares the desired form of a "hero" using the
`fake_hash' factory function.  The input is a hash-reference, with nested
generators created as placeholders by the `fake_name', `fake_sentences',
etc. factory functions:

    my $hero_generator = fake_hash(
        {
            name      => fake_name(),
            battlecry => fake_sentences(1),
            birthday  => fake_past_datetime("%%Y-%%m-%%d"),
            friends   => fake_array( fake_int(2,4), fake_name() ),
            gender    => fake_pick(qw/Male Female Other/),
        }
    );

Every time `$hero_generator' is run, a new hash is generated based
on the template and nested generators.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README LICENSE Changes examples
%perl_vendor_privlib/D*

%changelog
