# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Compress/Zlib.pm) perl(Constant/FromGlobal.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Uncompress/AnyInflate.pm) perl(JSON/XS.pm) perl(List/Util.pm) perl(Moose.pm) perl(MooseX/ClassAttribute.pm) perl(MooseX/Types.pm) perl(MooseX/Types/Moose.pm) perl(MooseX/Types/Structured.pm) perl(Scalar/Util.pm) perl(Sereal/Decoder.pm) perl(Sereal/Encoder.pm) perl(Storable.pm) perl(Test/More.pm) perl(autodie.pm)
# END SourceDeps(oneline)
%define module_version 1.10
%define module_name Data-FlexSerializer
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.10
Release: alt1
Summary: Pluggable (de-)serialization to/from compressed/uncompressed JSON/Storable/Sereal/Whatever
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/A/AV/AVAR/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This module was written to convert away from Storable throughout the
Booking.com codebase to other serialization formats such as Sereal and
JSON.

Since we needed to do these migrations in production we had to do them
with zero downtime and deal with data stored on disk, in memcached or
in a database that we could only gradually migrate to the new format
as we read/wrote it.

So we needed a module that deals with dynamically detecting what kind
of existing serialized data you have, and can dynamically convert it
to something else as it's written again.

That's what this module does. Depending on the options you give it it
can read/write any combination of
compressed/uncompressed/maybe compressed
Storable/JSON/Sereal data. You can also easily extend it to
add support for your own input/output format in addition to the
defaults.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes
%perl_vendor_privlib/D*

%changelog
