# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Class/Default.pm) perl(Config.pm) perl(Cwd.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(FileHandle.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Module/Install.pm) perl(Net/FTP.pm) perl(Params/Util.pm) perl(Socket.pm) perl(Test/More.pm) perl(YAML/Tiny.pm) perl(inc/Module/Install.pm) perl(inc/Module/Install/DSL.pm)
# END SourceDeps(oneline)
%define module_version 1.03
%define module_name Data-JavaScript-Anon
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.03
Release: alt1
Summary: Dump big dumb Perl structs to anonymous JavaScript structs
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/A/AD/ADAMK/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
Data::JavaScript::Anon provides the ability to dump large simple data
structures to JavaScript. That is, things that don't need to be a class,
or have special methods or whatever.

The method it uses is to write anonymous variables, in the same way you
would in Perl. The following shows some examples.

  # Perl anonymous array
  [ 1, 'a', 'Foo Bar' ]
  
  # JavaScript equivalent ( yes, it's exactly the same )
  [ 1, 'a', 'Foo Bar' ]
  
  # Perl anonymous hash
  { foo => 1, bar => 'bar' }
  
  # JavaScript equivalent
  { foo: 1, bar: 'bar' }

One advantage of doing it in this method is that you do not have to
co-ordinate variable names between your HTML templates and Perl. You
could use a simple Template Toolkit phrase like the following to get
data into your HTML templates.

  var javascript_data = [%% data %%];

In this way, it doesn't matter WHAT the HTML template calls a
particular variables, the data dumps just the same. This could help
you keep the work of JavaScript and Perl programmers ( assuming you
were using different people ) seperate, without creating 
cross-dependencies between their code, such as variable names.

The variables you dump can also be of arbitrary depth and complexity,
with a few limitations.

=over 4

=item ARRAY and HASH only

Since arrays and hashs are all that is supported by JavaScript, they
are the only things you can use in your structs. Any references or a
different underlying type will be detected and an error returned.

Note that Data::JavaScript::Anon will use the UNDERLYING type of the
data. This means that the blessed classes or objects will be ignored
and their data based on the object's underlying implementation type.

This can be a positive thing, as you can put objects for which you expect
a certain dump structure into the data to dump, and it will convert to 
unblessed, more stupid, JavaScript objects cleanly.

=item No Circular References

Since circular references can't be defined in a single anonymous struct,
they are not allowed. Try something like the Data::JavaScript manpage instead.
Although not supported, they will be detected, and an error returned.

=back


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes LICENSE
%perl_vendor_privlib/D*

%changelog
