# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Cwd.pm) perl(Data/Dumper.pm) perl(Env.pm) perl(Fatal.pm) perl(File/Basename.pm) perl(File/Copy.pm) perl(File/Path.pm) perl(FindBin.pm) perl(List/MoreUtils.pm) perl(List/Util.pm) perl(Module/Build/Tiny.pm) perl(Moo.pm) perl(MooX/Types/MooseLike/Base.pm) perl(Scalar/Classify.pm) perl(Scalar/Util.pm) perl(Test/Deep.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(Test/Trap.pm) perl(lib.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define module_name Data-Math
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.01
Release: alt1
Summary: arithmetic operations on complex data structures
Group: Development/Perl
License: perl
URL: https://github.com/doomvox/data-math

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/D/DO/DOOM/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Data::Math is for doing arithmetic operations on roughly
parallel data structures.

It's pretty clear what a line like this would be meant to do,
though Perl does nothing useful with it:

   %%net = %%gross - %%costs;

Instead, Data::Math's calc method can be used:

   my $net = $dm->calc( '-', \%%gross, \%%costs );

The code here is customizeable in many ways, but has
defaults that should make it easy to use in simple
cases.  The arithmetic operator is applied to numbers,
strings are just passed through if both sides are the same,
or concatenated (with '|' separator) if they differ.

If there's a numeric field you don't want to do numeric
operations on (e.g. 'tax_rate') you can define a pattern
in the object's skip_key_patterns array to skip it.


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE README
%perl_vendor_privlib/D*

%changelog
