# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(English.pm) perl(Exporter.pm) perl(Scalar/Util.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Data-Miscellany
%define upstream_version 1.100850

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt2_10

Summary:    Collection of miscellaneous subroutines
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Data/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Test/Compile.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(UNIVERSAL/require.pm)
BuildArch: noarch
Source44: import.info


%description
This is a collection of miscellaneous subroutines useful in wide but
varying scenarios; a catch-all module for things that don't obviously
belong anywhere else. Obviously what's useful differs from person to
person, but this particular collection should be useful in object-oriented
frameworks, such as the Class::Framework manpage and the Data::Conveyor
manpage.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%{make}

%check
%{make} test

%install
%makeinstall_std

%files
%doc Changes README META.yml
%perl_vendor_privlib/*

%changelog
