# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Test/Pod.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Data-Morph
%define upstream_version 1.140400

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt2_8

Summary:    Provides a Data::Morph backend for talking to objects
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Data/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(DBD/SQLite.pm)
BuildRequires: perl(DBIx/Class.pm)
BuildRequires: perl(DBIx/Class/Core.pm)
BuildRequires: perl(DBIx/Class/Schema.pm)
BuildRequires: perl(Data/DPath.pm)
BuildRequires: perl(Devel/PartialDump.pm)
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(Moose.pm)
BuildRequires: perl(Moose/Util/TypeConstraints.pm)
BuildRequires: perl(MooseX/Params/Validate.pm)
BuildRequires: perl(MooseX/Role/Parameterized.pm)
BuildRequires: perl(MooseX/Types/Moose.pm)
BuildRequires: perl(MooseX/Types/Structured.pm)
BuildRequires: perl(SQL/Translator.pm)
BuildRequires: perl(Scalar/Util.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(Try/Tiny.pm)
BuildRequires: perl(base.pm)
BuildRequires: perl(namespace/autoclean.pm)
BuildRequires: perl(strict.pm)
BuildRequires: perl(warnings.pm)
BuildArch:  noarch
Source44: import.info

%description
Data::Morph is a module that provides a solution for translating data from
one source to another via maps and backends. It is written such that data
can be shifted both directions. The the /SYNOPSIS manpage demonstrates a
somewhat trivial example of using the the Data::Morph::Backend::Object
manpage and the Data::Morph::Backend::Raw manpage that round trips the
defaults out the Foo class to a hash and back again. Not shown is the other
shipped backend the Data::Morph::Backend::DBIC manpage which operates on
the DBIx::Class::Row manpage objects. If a more specialized backend is
needed take a look at consuming the Data::Morph::Role::Backend manpage.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}
# Randomly fails https://rt.cpan.org/Ticket/Display.html?id=85653
rm -f t/01-basic.t

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
make test

%install
%makeinstall_std

%files
%doc Changes LICENSE META.json META.yml  README
%perl_vendor_privlib/*

%changelog
