# BEGIN SourceDeps(oneline):
BuildRequires: perl(Data/Printer.pm) perl(ExtUtils/MakeMaker.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_version 0.3
%define module_name Data-Printer-Filter-JSON
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.3
Release: alt1
Summary: pretty-print your decoded JSON structures!
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/N/NU/NUBA/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
Almost every JSON decoder on CPAN handles JavaScript's booleans with objects, and some
even reuse them in the resulting data structure. The result? A tiny JSON like this:

    {
      "alpha": true,
      "beta" : false,
      "gamma": true,
      "zeta" : false
    }

Results in this Data::Printer output:

    \ {
        alpha   JSON::XS::Boolean  {
            Parents       JSON::Boolean
            public methods (0)
            private methods (1) : __ANON__
            internals: 1
        },
        beta    JSON::XS::Boolean  {
            Parents       JSON::Boolean
            public methods (0)
            private methods (1) : __ANON__
            internals: 0
        },
        gamma   var{alpha},
        zeta    var{beta}
    }

While all I wanted was this:

    \ {
        alpha   true,
        beta    false,
        gamma   true,
        zeta    false
    }

This module fixes that! :)


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/D*

%changelog
