# BEGIN SourceDeps(oneline):
BuildRequires: perl(Module/Build/Tiny.pm) perl(Test/More.pm) perl(Test/Synopsis/Expectation.pm)
# END SourceDeps(oneline)
%define module_name Data-Queue-Batch
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.04
Release: alt1
Summary: FIFO data structure for "batching" items
Group: Development/Perl
License: perl
URL: https://github.com/i110/Data-Queue-Batch

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/I/IL/ILLO/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This is a simple FIFO data structure library to dequeue items by configured batch size.

This will be usable for processing items in batch, like bulk insertion to the database, etc.

For clarification, imagine the following queue:

    <- head
    [ ooooo | ooo ]

This queue's `batch_size' is 5, and there are 8 items in the queue.
But you can see only first 5 items, and can't dequeue / peek last 3 items, because the second *batch* hasn't been filled yet.

Then, push additional 3 items:

    <- head
    [ ooooo | ooooo | o ]

At this time, you can retrieve fist 10 items since the first and second *batch*es get filled.

Let's dequeue 2 items. After that, the queue can be described as the following:

    <- head
    [ ooo | ooooo | o ]

You can dequeue / peek the first 8 items, but the last element is still not available yet.


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE README.md
%perl_vendor_privlib/D*

%changelog
