# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Module/Runtime.pm) perl(Test/More.pm) perl(Try/Tiny.pm)
# END SourceDeps(oneline)
%define module_name Data-Random-Flexible
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.06
Release: alt1
Summary: Flexible fast-to-write profilable randoms
Group: Development/Perl
License: bsd
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/D/DA/DAEMON/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
A more flexible set of randoms for when you want to be random FAST

    use Data::Random::Flexible;

    use feature "say";

    my $random = Data::Random::Flexible->new();

    say "32 Characters of random numbers?, sure: ".$random->int(32);

    say "16 Characters of random letters?, sure: ".$random->char(16);

    say "16 Of a mixture of numbers and letters?, sure: ".$random->mix(16);

    say "Random mixture of 16 your own characters?, sure: ".$random->profile('irc',16, [qw(I r C 1 2 3)]);
    
    say "Random mixture of 16 your own characters from a saved profile?, sure: ".$random->profile('irc',16);

The module can also use alternative providers for rand(), for more detail look at the engine() function,
the currently supported providers of random are:

        Math::Random::Secure
        Math::Random::MTwist
        Math::Random::Xorshift
        Math::Random::MT
        Math::Random::ISAAC
        Math::Random::ISAAC::XS (Not selectable will be used AUTO if availible by Math::Random::ISAAC)
        Crypt::PRNG
        Your own code reference.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/D*

%changelog
