%define module_name Data-Record-Serialize
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Capture/Tiny.pm) perl(Convert/Scalar.pm) perl(Cpanel/JSON/XS.pm) perl(Data/Dumper.pm) perl(Exporter/Tiny.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Slurper.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(JSON/PP.pm) perl(List/Util.pm) perl(Module/Build/Tiny.pm) perl(Module/Version.pm) perl(Moo/Role.pm) perl(Package/Variant.pm) perl(Path/Tiny.pm) perl(Ref/Util.pm) perl(Scalar/Util.pm) perl(String/RewritePrefix.pm) perl(Test/Lib.pm) perl(Test/More.pm) perl(Test/TempDir/Tiny.pm) perl(Test2/Bundle/More.pm) perl(Test2/Plugin/NoWarnings.pm) perl(Test2/V0.pm) perl(Type/Library.pm) perl(Type/Utils.pm) perl(Types/Standard.pm) perl(YAML/PP.pm) perl(YAML/XS.pm) perl(custom/failures.pm) perl(enum.pm) perl(namespace/clean.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 2.01
Release: alt1
Summary: Flexible serialization of a record
Group: Development/Perl
License: gpl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/D/DJ/DJERIUS/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Data::Record::Serialize encodes data records and sends them
somewhere. This module is primarily useful for output of sets of
uniformly structured data records.  It provides a uniform, thin,
interface to various serializers and output sinks.  Its *raison
d'etre* is its ability to manipulate the records prior to encoding
and output.

=over

=item *

A record is a collection of fields, i.e. keys and *scalar*
values.

=item *

All records are assumed to have the same structure.

=item *

Fields may have simple types which may be determined automatically.
Some encoders use this information during encoding.

=item *

Fields may be renamed upon output

=item *

A subset of the fields may be selected for output.

=item *

Fields may be formatted via `sprintf' prior to output

=back


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc CONTRIBUTING.md README LICENSE Changes
%perl_vendor_privlib/D*

%changelog
