# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Class/Accessor/Fast.pm) perl(Config.pm) perl(Cwd.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(FileHandle.pm) perl(Module/Build.pm) perl(Moose.pm) perl(Test/Builder/Module.pm) perl(YAML/Tiny.pm)
# END SourceDeps(oneline)
%define module_version 0.00003
%define module_name Data-ResourceSet
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.00003
Release: alt1
Summary: A Bundle Of Resources
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/D/DM/DMAKI/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
Data::ResourceSet is a bag of "stuff", where you can refer to the "stuff"
by name, and the "stuff" will be initialized for you.

For example, say you have multiple DBIx::Class::Schema objects in your
app. You would like to make the reference to each resource as abstract
as possible so you don't hard code anything. Then you can create an
instance of Data::ResourceSet and refer to these schemas by name.

Here are two ways to do it. First is to simply create a resource set from
already instantiated schemas:

  my $schema1 = MyCluster1->connect($dsn, $user, $pass);
  my $schema2 = MyCluster2->connect($dsn, $user, $pass);
  my $resources = Data::ResourceSet->new({
    resources => {
      schema => {
        cluster1 => $schema1,
        cluster2 => $schema2,
      }
    }
  });

  $resources->resource('schema', 'cluster1')->resultset('FooBar')->search(...)

The other way to do it is by giving a similar hash, but give only the config

  my $resources = Data::ResourceSet->new({
    resources_config => {
      schema => {
        cluster1 => {
          module      => '+DBIx::Class::Schema',
          consturctor => 'connect',
          args        => [ $dsn, $user, $pass ],
        },
        cluster2 => {
          module      => '+DBIx::Class::Schema',
          consturctor => 'connect',
          args        => [ $dsn, $user, $pass ],
        }
      }
    }
  });
  $resources->resource('schema', 'cluster1')->resultset('FooBar')->search(...)

The difference between the first and the second example above is that
the latter does a lazy initialization. So if you don't want to connect
until you actually use the connection, then the second way is the way to go.

You can also specify this config on a per-package level, say, when you subclass
Data::ResourceSet:

  package MyApp::ResourceSet;
  use base qw(Data::ResourceSet);

  __PACKAGE__->config(
    resources => {
      schema => {
        cluster1 => {
          module      => '+DBIx::Class::Schema',
          consturctor => 'connect',
          args        => [ $dsn, $user, $pass ],
        },
        cluster2 => {
          module      => '+DBIx::Class::Schema',
          consturctor => 'connect',
          args        => [ $dsn, $user, $pass ],
        }
      }
    }
  });

  my $resources = MyApp::ResourceSet->new;
  $resources->resource('schema', 'cluster1')->resultset('FooBar')->search(...)

You can also use Data::ResourceSet::Adaptor, which can be a proxy between
Data::ResourceSet and your actual resource.

  package MyProxy;
  use base qw(Data::ResourceSet::Adaptor);

  sub ACCEPT_CONTEXT
  {
    my($self, $c, @args) = @_;
    ...
    return $whatever;
  }

  my $resource = Data::ResourceSet->new({
    resource_config => {
      foo => {
        bar => {
          module => '+MyProxy',
          args   => \%%whatever
        }
      }
    }
  });


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes
%perl_vendor_privlib/D*

%changelog
