%define module_name Data-Roundtrip
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Benchmark.pm) perl(Data/Dump.pm) perl(Data/Dump/Filtered.pm) perl(Data/Dumper.pm) perl(Data/Random/Structure.pm) perl(Data/Random/Structure/UTF8.pm) perl(Encode.pm) perl(Encode/CN.pm) perl(Encode/JP.pm) perl(Encode/KR.pm) perl(Encode/TW.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(File/Temp.pm) perl(JSON.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(Test/Script.pm) perl(Test/Taint.pm) perl(Test2/Plugin/UTF8.pm) perl(Unicode/Escape.pm) perl(YAML/PP.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.26
Release: alt1
Summary: convert between Perl data structures, YAML and JSON with unicode support (I believe ...)
Group: Development/Perl
License: artistic_2
URL: https://metacpan.org/module/Data::Roundtrip

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/B/BL/BLIAKO/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module contains a collection of utilities for converting between
JSON, YAML, Perl variable and a Perl variable's string representation (aka dump).
Hopefully, all unicode content will be handled correctly between
the conversions and optionally escaped or un-escaped. Also JSON can
be presented in a pretty format or in a condensed, machine-readable
format (not spaces, indendation or line breaks).


    use Data::Roundtrip qw/:all/;

    $jsonstr = '{"Songname": ".'.e.'.a.O...'.Y.' .'...' .a.Y.v.A.'.A.U.N.'", "Artist": ".'.N.c.N.A.'.c.U.E...' .e.'.d.O.v.Y.'/.'.U.'.B.Y.' .'.'.'.'.N.'"}';
    $yamlstr = json2yaml($jsonstr);
    print $yamlstr;
    #---
    #Artist: .'.N.c.N.A.'.c.U.E...' .e.'.d.O.v.Y.'/.'.U.'.B.Y.' .'.'.'.'.N.'
    #Songname: .'.e.'.a.O...'.Y.' .'...' .a.Y.v.A.'.A.U.N.'

    $yamlstr = json2yaml($jsonstr, {'escape-unicode'=>1});
    print $yamlstr;
    #---
    #Artist: \u039a\u03b1\u03b6\u03b1\u03bd\u03c4\u03b6\u03af\u03b4\u03b7\u03c2 \u03a3\u03c4\u03ad\u03bb\u03b9\u03bf\u03c2/\u0392\u03af\u03c1\u03b2\u03bf\u03c2 \u039a\u03ce\u03c3\u03c4\u03b1\u03c2
    #Songname: \u0391\u03c0\u03cc\u03ba\u03bb\u03b7\u03c1\u03bf\u03c2 \u03c4\u03b7\u03c2 \u03ba\u03bf\u03b9\u03bd\u03c9\u03bd\u03af\u03b1\u03c2

    $backtojson = yaml2json($yamlstr);
    # $backtojson is a string representation of this JSON structure:
    # {"Artist":".'.N.c.N.A.'.c.U.E...' .e.'.d.O.v.Y.'/.'.U.'.B.Y.' .'.'.'.'.N.'","Songname":".'.e.'.a.O...'.Y.' .'...' .a.Y.v.A.'.A.U.N.'"}

    # This is useful when sending JSON via a POST request and it needs unicode escaped:
    $backtojson = yaml2json($yamlstr, {'escape-unicode'=>1});

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %EVR

%description scripts
scripts for %module_name
    # $backtojson is a string representation of this JSON structure:
    # but this time with unicode escaped
    # {"Artist":"\u039a\u03b1\u03b6\u03b1\u03bd\u03c4\u03b6\u03af\u03b4\u03b7\u03c2 \u03a3\u03c4\u03ad\u03bb\u03b9\u03bf\u03c2/\u0392\u03af\u03c1\u03b2\u03bf\u03c2 \u039a\u03ce\u03c3\u03c4\u03b1\u03c2","Songname":"\u0391\u03c0\u03cc\u03ba\u03bb\u03b7\u03c1\u03bf\u03c2 \u03c4\u03b7\u03c2 \u03ba\u03bf\u...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README README.md Changes
%perl_vendor_privlib/D*

%files scripts
%_man1dir/*
%_bindir/*

%changelog
