%define module_name Data-Sah-Coerce
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(File/Temp.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(IPC/System/Options.pm) perl(JSON.pm) perl(JavaScript/QuickJS.pm) perl(Log/ger.pm) perl(Nodejs/Util.pm) perl(Pod/Coverage/TrustPod.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(Test/Needs.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(Time/Duration/Parse/AsHash.pm) perl(Time/Local.pm) perl(strict.pm) perl(subroutines.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.054
Release: alt1
Summary: Coercion rules for Data::Sah
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Data-Sah-Coerce

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PE/PERLANCAR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This distribution contains a standard set of coercion rules for the Data::Sah manpage. It
is separated from the `Data-Sah' distribution and can be used independently.

A coercion rule is put in
`Data::Sah::Coerce::$COMPILER::$TARGET_TYPE::$SOURCE_TYPE_AND_EXTRA_DESCRIPTION'
module, for example: the Data::Sah::Coerce::perl::date::float_epoch manpage for
converting date from integer (Unix epoch) or
the Data::Sah::Coerce::perl::date::str_iso8601 manpage for converting date from ISO8601
strings like "2016-05-15".

Basically, a coercion rule will provide an expression (`expr_match') that
evaluates to true when data can be coerced, and an expression (`expr_coerce')
to actually coerce/convert data to the target type. This rule can be combined
with other rules to form the final coercion code.

The module must contain `meta' subroutine which must return a hashref that has
the following keys (`*' marks that the key is required):

=over

=item * v* => int (default: 1)

Metadata specification version. Currently at 2 (bumped from 1 to exclude old
module names).

=item * enable_by_default* => bool

Whether the rule should be used by default. Some rules might be useful in
certain situations only and can set this key's value to 0.

To explicitly enable a disabled-by-default rule or explicitly disable an
enabled-by-default rule, a Sah schema can set the attribute `x.coerce_rules' or
`x.perl.coerce_rules' to something like `["!str_iso8601", "str_alami"]'
(this means to exclude the `str_iso8601' rule but enable the `str_alami'
rule).

=item * might_die => bool (default: 0)

Whether the rule will generate code that might die (e.g. does not trap failure
in a conversion process). An example of a rule like this is coercing from string
in the form of "YYYY-MM-DD" to a DateTime object. The rule might match any
string in the form of `/\A(\d{4})-(\d{2})-(\d{2})\z/' and feed it to `DateTime->new', without checking of a valid date, so the DateTime object
construction might die.

An example of rule that "might not die" is coercing fro...
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README LICENSE
%perl_vendor_privlib/D*

%changelog
