%define module_name Data-Sah-Filter
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Data/Dmp.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(File/Temp.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(IPC/System/Options.pm) perl(JSON.pm) perl(Log/ger.pm) perl(Nodejs/Util.pm) perl(Pod/Coverage/TrustPod.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.025
Release: alt1
Summary: Filtering for Data::Sah
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Data-Sah-Filter

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PE/PERLANCAR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This distribution contains a standard set of filter rules for the Data::Sah manpage (to
be used in `prefilters' and `postfilter' cause). It is separated from the
`Data-Sah' distribution and can be used independently.

A filter rule is put in `Data::Sah::Filter::$COMPILER::$CATEGORY:$DESCRIPTION'
module, for example: the Data::Sah::Filter::perl::Str::trim manpage for trimming
whitespace at the beginning and end of string.

Basically, a filter rule will provide an expression (`expr_filter') to convert
data to another. Multiple filter rules will be combined to form the final
filtering code.

The filter rule module must contain `meta' subroutine which must return a
hashref (the DefHash manpage) that has the following keys (`*' marks that the key is
required):

=over

=item * v* => int (default: 1)

Metadata specification version. From the DefHash manpage. Currently at 1.

=item * summary => str

From the DefHash manpage.

=back

The filter rule module must also contain `filter' subroutine which must
generate the code for filtering. The subroutine must accept a hash of arguments
(`*' indicates required arguments):

=over

=item * data_term => str

=back

The `filter' subroutine must return a hashref with the following keys (`*'
indicates required keys):

=over

=item * might_fail => bool

Whether coercion might fail, e.g. because of invalid input. If set to 1,
`expr_filter' key that the `filter()' routine returns must be an expression
that returns an array (envelope) of `(error_msg, data)' instead of just
filtered data. Error message should be a string that is set when filtering fails
and explains why. Otherwise, if filtering succeeds, the string should be set to
undefined value.

This is used for filtering rules that act as a data checker.

=item * expr_filter => str

Expression in the target language to actually convert data.

=item * modules => hash

A list of modules required by the expression.

=back

Basically, the `filter' subroutine must generate a code that accepts a
non-undef data and must convert th...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes LICENSE
%perl_vendor_privlib/D*

%changelog
