%filter_from_requires /^perl.arybase.pm./d
%define module_version 4.6
%define module_name Data-ShowTable
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 4.6
Release: alt2
Summary: Perl module to automatically format columnar data.
Group: Development/Perl
License: open_source
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/A/AK/AKSTE/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
The ShowTable module provides subroutines to display tabular data,
typially from a database, in nicely formatted columns, in several formats.
Its arguments can either be given in a fixed order, or, as
a single, anonymous hash-array.

The output format for any one invocation can be one of four possible styles:

=over 10

=item Box

A tabular format, with the column titles and the entire table surrounded by a
"box" of "`+'", "`-'", and "`|'" characters.  See the section on "ShowBoxTable" for details.

=item Table

A simple tabular format, with columns automatically aligned, with column titles.
See the section on "ShowSimpleTable".

=item List

A *list* style, where columns of data are listed as a *name*:*value* pair, one
pair per line, with rows being one or more column values, separated by an empty line.
See the section on "ShowListTable".

=item HTML

The data is output as an HTML *TABLE*, suitable for display through a *Web*-client.
See the section on "ShowHTMLTable".  Input can either be plain ASCII text, or text
with embedded HTML elements, depending upon an argument or global parameter.

=back

The subroutines which perform these displays are listed below.

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %{?epoch:%epoch:}%name = %version-%release

%description scripts
scripts for %module_name


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build INSTALLMAN1DIR=%_man1dir

%install
%perl_vendor_install

%files
%doc Copyright Changes README
%perl_vendor_privlib/D*

%files scripts
%_man1dir/*
%_bindir/*

%changelog
