# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Exporter.pm) perl(base.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Data-Struct
%define upstream_version 1.701

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt2_11

Summary:    Simple struct building
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Data/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(Test/More.pm)
BuildArch:  noarch
Source44: import.info

%description
This module implements a very basic and easy to use struct builder.

A _struct_ is a data structure that can contain values (attributes). The
values of the attributes can be set at creation time, and read and modified
at run time. Attributes can be anything that Perl can handle. There's no
checking on types. You may want to use the Class::Struct manpage if you
need _struct_s with type checking and inheritance.

Objects are much more powerful. Besides data, they can contain behaviour
(methods), support inheritance and encapsulation. This module deals with
data structures and not Objects, so I took placed it under the Data::
hierarchy.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc Changes META.yml README
%perl_vendor_privlib/*

%changelog
