# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Carp.pm) perl(Config.pm) perl(Cwd.pm) perl(Data/Timeline.pm) perl(Data/Timeline/Builder.pm) perl(Data/Timeline/Formatter/HTML.pm) perl(Data/Timeline/Formatter/SimpleTable.pm) perl(DateTime/Format/DateParse.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(File/Spec.pm) perl(FileHandle.pm) perl(FindBin.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(Socket.pm) perl(Test/Builder.pm) perl(Test/Builder/Module.pm) perl(YAML.pm) perl(base.pm) perl(inc/Module/Install.pm)
# END SourceDeps(oneline)
%define module_version 0.02
%define module_name Data-Timeline-IScrobbler
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.02
Release: alt1
Summary: Build a timeline from tracks recorded by iScrobbler
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/M/MA/MARCEL/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
This class parses the logs created by the Mac OS X application iScrobbler and
creates a timeline of the recently played tracks. iScrobbler is an
application for Mac OS X that creates a simple menu extra that submits your
"currently playing" info from iTunes to AudioScrobbler. The advantage over
using the AudioScrobbler web service is that iScrobbler keeps a lot more
recently played tracks history than the web service. See its page at
http://iscrobbler.sourceforge.net/.

The timeline entries generated by this builder have the type `iscrobbler'.

See the `eg/hackmusic-text.pl' and `eg/hackmusic-html.pl' programs in this
distribution for examples. The idea for those programs was inspired by Greg
McCarroll's blog post "Optimal Hacking Music" at
http://drinkbroken.typepad.com/drink_broken/2007/11/set-the-hack--1.html. The
programs show timelines of your recently played iTunes tracks history
alongside your svk commit history and thus give an impression of which music
you like to hack to.

Data::Timeline::IScrobbler inherits from the Data::Timeline::Builder manpage.

The superclass the Data::Timeline::Builder manpage defines these methods and
functions:

    new(), make_entry(), make_timeline()

The superclass the Class::Accessor::Complex manpage defines these methods and
functions:

    carp(), cluck(), croak(), flatten(), mk_abstract_accessors(),
    mk_array_accessors(), mk_boolean_accessors(),
    mk_class_array_accessors(), mk_class_hash_accessors(),
    mk_class_scalar_accessors(), mk_concat_accessors(),
    mk_forward_accessors(), mk_hash_accessors(), mk_integer_accessors(),
    mk_new(), mk_object_accessors(), mk_scalar_accessors(),
    mk_set_accessors(), mk_singleton()

The superclass the Class::Accessor manpage defines these methods and functions:

    _carp(), _croak(), _mk_accessors(), accessor_name_for(),
    best_practice_accessor_name_for(), best_practice_mutator_name_for(),
    follow_best_practice(), get(), make_accessor(), make_ro_accessor(),
    make_wo_accessor(), mk_accessors(), mk_ro_accessors(),
    mk_wo_accessors(), mutator_name_for(), set()

The superclass the Class::Accessor::Installer manpage defines these methods and
functions:

    install_accessor(), subname()

The superclass the Class::Accessor::Constructor manpage defines these methods and
functions:

    NO_DIRTY(), WITH_DIRTY(), _make_constructor(), mk_constructor(),
    mk_constructor_with_dirty(), mk_singleton_constructor()

The superclass the Data::Inherited manpage defines these methods and functions:

    every_hash(), every_list(), flush_every_cache_by_key()

The superclass the Class::Accessor::Constructor::Base manpage defines these methods
and functions:

    HYGIENIC(), STORE(), clear_dirty(), clear_hygienic(),
    clear_unhygienic(), contains_hygienic(), contains_unhygienic(),
    delete_hygienic(), delete_unhygienic(), dirty(), dirty_clear(),
    dirty_set(), elements_hygienic(), elements_unhygienic(), hygienic(),
    hygienic_clear(), hygienic_contains(), hygienic_delete(),
    hygienic_elements(), hygienic_insert(), hygienic_is_empty(),
    hygienic_size(), insert_hygienic(), insert_unhygienic(),
    is_empty_hygienic(), is_empty_unhygienic(), set_dirty(),
    size_hygienic(), size_unhygienic(), unhygienic(), unhygienic_clear(),
    unhygienic_contains(), unhygienic_delete(), unhygienic_elements(),
    unhygienic_insert(), unhygienic_is_empty(), unhygienic_size()

The superclass the Tie::StdHash manpage defines these methods and functions:

    CLEAR(), DELETE(), EXISTS(), FETCH(), FIRSTKEY(), NEXTKEY(), SCALAR(),
    TIEHASH()


%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/D*

%changelog
