%define module_name Data-Transfigure
# BEGIN SourceDeps(oneline):
BuildRequires: perl(DBD/SQLite.pm) perl(DBIx/Class.pm) perl(DBIx/Class/InflateColumn/Time.pm) perl(DBIx/Class/Relationship/Predicate.pm) perl(Data/Compare.pm) perl(DateTime.pm) perl(DateTime/Duration.pm) perl(DateTime/Format/Duration/ISO8601.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(JSON/Validator.pm) perl(Module/Util.pm) perl(Object/Pad.pm) perl(Readonly.pm) perl(String/CamelSnakeKebab.pm) perl(Test/More.pm) perl(Test2/Suite.pm) perl(XS/Parse/Keyword.pm) perl(XS/Parse/Sublike.pm) perl(experimental.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.03
Release: alt1
Summary: performs rule-based data transfigurations of arbitrary structures
Group: Development/Perl
License: mit
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/T/TY/TYRRMINAL/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
`Data::Transfigure' allows you to write reusable rules ('transfigurators') to modify
parts (or all) of a data structure. There are many possible applications of this,
but it was primarily written to handle converting object graphs of ORM objects
into a structure that could be converted to JSON and delivered as an API endpoint
response. One of the challenges of such a system is being able to reuse code
because many different controllers could need to convert the an object type to
the same structure, but then other controllers might need to convert that same
type to a different structure.

A number of transfigurator roles and classes are included with this distribution:

=over

=item * the Data::Transfigure::Node manpage
the root role which all transfigurators must implement

=item * the Data::Transfigure::Default manpage
a low priority transfigurator that only applies when no other transfigurators do

=item * the Data::Transfigure::Default::ToString manpage
a transfigurator that stringifies any value that is not otherwise transfigured

=item * the Data::Transfigure::Type manpage
a transfigurator that matches against one or more data types

=item * the Data::Transfigure::Type::DateTime manpage
transfigures DateTime objects to ISO8601 
format.

=item * the Data::Transfigure::Type::DateTime::Duration manpage
transfigures the DateTime::Duration manpage objects to 
ISO8601 (duration!) format

=item * the Data::Transfigure::Type::DBIx manpage
transfigures the DBIx::Class::Row manpage instances into hashrefs of colname->value 
pairs. Does not recurse across relationships

=item * the Data::Transfigure::Type::DBIx::Recursive manpage
transfigures the DBIx::Class::Row manpage instances into hashrefs of colname->value pairs,
recursing down to_one-type relationships

=item * the Data::Transfigure::Value manpage
a transfigurator that matches against data values (exactly, by regex, or by coderef 
callback)

=item * the Data::Transfigure::Position manpage
a compound transfigurator that specifies one or more locations wit...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README README.md LICENSE Changes doc
%perl_vendor_privlib/D*

%changelog
