# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Storable/AMF0.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_name Data-Unique
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.02
Release: alt1
Summary: Module to check for duplicate item with time expiration and disk persistence.
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/F/FD/FDULAU/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Create a data structure that avoid duplicate entries (key) whith any data and add expiration time to clean old entries.
This module use  Storable::AMF0 for the persistence.
After some benchmark of various serialisation it is best compromise in read and write for huge quantity of data.

e.g.


        #!/usr/bin/perl
_  
_use strict;
_use warnings;
_use Data::Dumper;
_use feature qw( say );
_use Time::HiRes qw(gettimeofday usleep );
_
_use Data::Unique;
_
_
_
_my $filename = '/tmp/dedup.test';
_my @dup;
_my $dedup = Data::Unique->new( { expiration => 10, file => $filename, gc => 5 } );
_
_for my $idx ( 1 .. 6 ) {
_    my ( $seconds, $microseconds ) = gettimeofday;
_    my $time = ( $seconds * 1000000 ) + $microseconds;
_    say "$idx -> $time";
_    $dedup->item( $time, { T => $idx } ) or say "no insertion ($$time already present)";
_    push @dup, $time if ( ( $idx %% 2 ) == 0 );
_    usleep 10;
_}
_say Data::Dumper::Dumper $dedup;
_say "Number of item=".$dedup->scalar;
_
_say "Expiration time ".$dedup->expiration;
_say "Number of item=".$dedup->scalar;
_
_say $dedup->expiration(6);
_sleep 15;
_
_#say "deleted item number=".$dedup->gc();
_say "Number of item=".$dedup->scalar;
_
_foreach my $ins (@dup) {
_   say  $dedup->item($ins, { T => time }) ? "inserting $ins" : "no insertion ($ins already present)";
_}
_
_say "Expiration time ".$dedup->expiration;
_say "Number of item=".$dedup->scalar. '  =>  '.scalar( keys( %%{ $dedup->{data} }));

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/D*

%changelog
