# BEGIN SourceDeps(oneline):
BuildRequires: perl(Net/DNS.pm) perl(Net/SMTP.pm)
# END SourceDeps(oneline)
%define module_name Data-Validate-Mailbox
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.12
Release: alt1
Summary: Verify that the given mailbox exists
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PY/PYH/%{module_name}-%{version}.tgz
BuildArch: noarch

%description
Verify that the given mailbox exists.

If you find any issues in using the module, please don't hesitate to email me: pyh@gmx.fr


    use Data::Validate::Mailbox;

    my $mbx = Data::Validate::Mailbox->new;

    # or,
    my $mbx = Data::Validate::Mailbox->new(debug => 1,
                                           localhost => 'your-domain.org',
                                           localuser => 'user@your-domain.org',
                                          );

    my $res = $mbx->validate('user123@gmx.de'); # or
    my $res = $mbx->validate('user123@gmail.com'); # or
    my $res = $mbx->validate('user123@hotmail.com'); # or 
    ...

    # 1 means existing, 0 means non-existing
    print $res;


Please note,

1. This module just uses Net::SMTP to try to deliver messages to peer MTA. If the remote mailbox doesn't exist, peer MTA will return a message such as "mailbox unavailable".

2. Some email providers don't behave like above, such as Yahoo/AOL, so this module won't work for them.

%prep
%setup -q -n %{module_name}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README ignore.txt
%perl_vendor_privlib/D*

%changelog
