%define module_name Database-Async
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Class/Method/Modifiers.pm) perl(Database/Async/Engine/PostgreSQL/DDL.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(Future.pm) perl(Future/AsyncAwait.pm) perl(IO/Async.pm) perl(IO/Async/Notifier.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(JSON/MaybeUTF8.pm) perl(JSON/MaybeXS.pm) perl(List/Util.pm) perl(List/UtilsBy.pm) perl(Log/Any.pm) perl(Module/Load.pm) perl(Path/Tiny.pm) perl(Ryu.pm) perl(Ryu/Async.pm) perl(Scalar/Util.pm) perl(Syntax/Keyword/Try.pm) perl(Template.pm) perl(Test/CheckDeps.pm) perl(Test/Fatal.pm) perl(Test/More.pm) perl(Test/Refcount.pm) perl(URI.pm) perl(URI/db.pm) perl(XS/Parse/Keyword.pm) perl(XS/Parse/Sublike.pm) perl(YAML/XS.pm) perl(curry.pm) perl(experimental.pm) perl(indirect.pm) perl(mro.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.019
Release: alt1
Summary: database interface for use with IO::Async
Group: Development/Perl
License: perl
URL: https://github.com/team-at-cpan/Database-Async

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/T/TE/TEAM/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Database support for the IO::Async manpage. This is the base API, see the Database::Async::Engine manpage
and subclasses for specific database functionality.

This is an early preview release.

the DBI manpage provides a basic API for interacting with a database, but this is
very low level and uses a synchronous design. See the DBIx::Async manpage if you're
familiar with the DBI manpage and want an interface that follows it more closely.

Typically a database only allows a single query to run at a time.
Other queries will be queued.

Set up a pool of connections to provide better parallelism:

    my $dbh = Database::Async->new(
        uri  => 'postgres://write@maindb/dbname?sslmode=require',
        pool => {
            max => 4,
        },
    );

Queries and transactions will then automatically be distributed
among these connections. However, note that:

=over 4

=item * all queries within a transaction will be made on the same connection

=item * ordering guarantees are weaker: queries will be started in
order on the next available connection

=back

With a single connection, you could expect:

    Future->needs_all(
     $dbh->do(q{insert into x ...}),
     $dbh->do(q{select from x ...})
    );

to insert the rows first, then return them in the `select' call. With a pool of connections, that's not guaranteed.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE README doc
%perl_vendor_privlib/D*

%changelog
