%define module_name Database-Async-Engine-PostgreSQL
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Bytes/Random/Secure.pm) perl(Config/Tiny.pm) perl(CryptX.pm) perl(Database/Async.pm) perl(Encode.pm) perl(Encode/CN.pm) perl(Encode/JP.pm) perl(Encode/KR.pm) perl(Encode/TW.pm) perl(ExtUtils/MakeMaker.pm) perl(File/HomeDir.pm) perl(File/Spec.pm) perl(File/Temp.pm) perl(Future.pm) perl(Future/AsyncAwait.pm) perl(IO/Async/Loop.pm) perl(IO/Async/SSL.pm) perl(IO/Handle.pm) perl(IO/Socket/SSL.pm) perl(IPC/Open3.pm) perl(Log/Any.pm) perl(Log/Any/Adapter/TAP.pm) perl(Log/Any/Test.pm) perl(MIME/Base64.pm) perl(Path/Tiny.pm) perl(Protocol/Database/PostgreSQL.pm) perl(Ryu.pm) perl(Ryu/Async.pm) perl(Syntax/Keyword/Try.pm) perl(Template.pm) perl(Test/CheckDeps.pm) perl(Test/Deep.pm) perl(Test/Fatal.pm) perl(Test/MockModule.pm) perl(Test/More.pm) perl(Test/Refcount.pm) perl(URI/QueryParam.pm) perl(URI/postgres.pm)
BuildRequires: perl(Unicode/UTF8.pm) perl(XS/Parse/Keyword.pm) perl(XS/Parse/Sublike.pm) perl(curry.pm) perl(experimental.pm) perl(indirect.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.004
Release: alt1
Summary: PostgreSQL support for Database::Async
Group: Development/Perl
License: perl
URL: https://github.com/team-at-cpan/Database-Async-Engine-PostgreSQL

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/T/TE/TEAM/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Provide a `postgresql://' URI when instantiating the Database::Async manpage to use this engine.

 $loop->add(
  my $dbh = Database::Async->new(
   uri => 'postgresql://localhost'
  )
 );

Connection can also be made using a service definition, as described in https://www.postgresql.org/docs/current/libpq-pgservice.html.

 $loop->add(
  my $dbh = Database::Async->new(
   type => 'postgresql',
   engine => {
    service => 'example',
   }
  )
 );

If neither URI nor service are provided, the `PGSERVICE' environment variable is attempted, and will fall back
to localhost (similar to `psql -h localhost' behaviour).

 $loop->add(
  my $dbh = Database::Async->new(
   type => 'postgresql',
  )
 );

%prep
%setup -q -n %{module_name}-%{version}

%if "%version" == "0.012"
%define _without_test 1
%endif

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README LICENSE Changes examples
%perl_vendor_privlib/D*

%changelog
