# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_version 1.03
%define module_name Database-Format-Text
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.03
Release: alt1
Summary: Local database in text format.
Group: Development/Perl
License: Artistic_2_0
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/D/DE/DEVDOS/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
`Database::Format::Text' module is handy tool to create a text based database
on local machine. This module will create database in text format, so user 
can any time open the text file and look at the data. User will be able to do 
following manipulation on the data base using this module.

=over 4

=item * Add data

=item * Delete data

=item * Append data

=item * Get titles

=item * Get data

=item * Get whole data base

=item * Count entries

=back

To modify the existing entry, delete the existing entry and re-enter the modified 
entry. Following is the example to use `Database::Format::Text'

_use Database::Format::Text;
_my @titles = qw(Number Title Status Comments);

_# Create database
_my $foo_data_table = Database::Format::Text->new('file_name' => "foo_data", 
_______ 'fields' => \@titles);
_# Add entry
_my $status = $foo_data_table->add_entry("1", "Test1", "Pass", "Applicable");

_# Delete entry
_$status = $foo_data_table->delete_entry("Status", "Pass");

_# Get entry
_my @data = foo_data_table->get_entry("Number", 7);
_# or
_$status = foo_data_table->get_entry("Number", 7, "Status");

_# Get database
_my @database = $foo_data_table->get_table();

_# Count entries
_$status = $foo_data_table->count_entry("Status", "Pass");

_# Get titles
_@database = $foo_data_table->get_titles();

You can use this module at many places. Example : If you are a test engineer and
 you need to perform some test cases on your product this data base will help to
 store your records. It is in text based format so you can copy this data base 
in your archive for future reference.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/D*

%changelog
