# BEGIN SourceDeps(oneline):
BuildRequires: perl(Class/Accessor.pm) perl(Date/Calc.pm) perl(ExtUtils/MakeMaker.pm) perl(Test/More.pm) perl(base.pm)
# END SourceDeps(oneline)
%define module_name Date-Calc-Endpoints
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.03
Release: alt1
Summary: Generate start/end dates easily, based on type (year, month,...),
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/O/OL/OLENCHUK/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Date::Calc::Endpoints calculates a start/end date based on a interval type, and a number of intervals from the current date.
This is often required in running scheduled and ad-hoc reports using the same script, where the desired date range
has the requirement of, "7 months ago", or, "5 weeks ago, running Tuesday to Monday".

Three dates are returned for the given interval:

=over 4

=item

First date of the interval

=item

First date of the next interval

=item

Last date of the interval

=back

Two "end" dates are returned for convenience, as a report using a date+time field may require a query from
"2015-10-01 through 2015-11-01", but the title of the report may be, "Output for 2015-10-01 through 2015-10-31".

Date ranges are calculated based on the following parameters:

=over 4

=item 

type - the basic time interval for the report [ YEAR | QUARTER | MONTH | WEEK | DAY ] - no default, must be specified

Note: QUARTER calculates the ranges for (Jan-Mar / Apr-Jun / Jul-Sep / Oct-Dec)

=item

intervals - how many "units in the past" (eq, "4 months ago") - default = 1

=item

span - number of consecutive units (eq, "5 month window") - default = 1

=item

sliding_window - Applicable if span > 1.  If sliding_window is set, each interval back will slide by one
unit of type.  If sliding window is not set, each interval back will slide by (span) units of type. - default = 0

=item

direction - If set to "-", each positive value for "intervals" goes further into the past, and each negative value for "intervals"
goes further into the future.  If set to "+", the opposite applies.

=item

start_day_of_week - For type = WEEK, the day which should be used as the first day of the week (SUNDAY, MONDAY, ...) - default = MONDAY

=item

start_day_of_month - For type = MONTH, the day which should be used as the start date of the month.  Valid values are 1..28.
Date::Calc is used for these calculations.  If adding/subtracting months, and the day component of the start month is greater
than the number of days in the result...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install
rm -f %buildroot/usr/share/perl5/._Date

%files
%doc README Changes
%perl_vendor_privlib/D*

%changelog
