# BEGIN SourceDeps(oneline):
BuildRequires: perl(DateTime.pm) perl(DateTime/Format/Flexible.pm) perl(ExtUtils/MakeMaker.pm) perl(Moo.pm) perl(Scalar/Util.pm) perl(Test/More.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define module_name Date-RetentionPolicy
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.01
Release: alt1
Summary: Prune a list of dates down to the ones you want to keep
Group: Development/Perl
License: perl
URL: https://github.com/intellitree/perl-Date-RetentionPolicy

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/N/NE/NERDVANA/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Often when making backups of a thing, you want to have more frequent snapshots
for recent dates, but don't need that frequency further back in time, and want
to delete some of the older ones to save space.

The problem of deciding which snapshots to delete is non-trivial because
backups often don't complete on a timely schedule (despite being started on
a schedule) or have discontinuities from production mishaps, and it would be
bad if your script wiped out the only backup in an interval just because it
didn't look like one of the "main" timestamps.  Also it would be bad if the
jitter from the time zone or time of day that you run the pruning process
caused the script to round differently and delete the backups it had
previously decided to keep.

This module uses an algorithm where you first define the intervals which
should retain a backup, then assign the existing timestamps to those intervals
(possibly reaching across the interval boundary a bit in order to preserve
a nearby timestamp; see the reach_factor manpage) thus making an intelligent decision
about which timestamps to keep.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README
%perl_vendor_privlib/D*

%changelog
