# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm)
# END SourceDeps(oneline)
%define module_name Date-Vruceleto
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.01
Release: alt1
Summary: Compute year's vruceleto and solar cycle as used in old Russian calendar
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/R/RP/RPAVLOV/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Vruceletos (or vrutseletos) are similar to European Sunday letters
(see the Date::SundayLetter manpage) with a few differences:

- Letters are Cyrillic

- A January-based year has always 2 letters, not just a leap
  one. That's because March-based style is used.

Vruceleto (or vrutseleto) letters are Cyrillic letters .', .', .', .i, .',
.', .. (pronounced Az, Vedi, Glagol', Dobro, Yest', Zelo, Zemlya),
assigned sequentially to the days of the year in reverse order,
starting from the 1st of March being .'. Thus within a March-based year
(common among East Slavs until 1492) each letter corresponds to the
same day of the week, the letter corresponding to Sunday being called
"the vruceleto of the year". The latter then could be used for Easter
calculations and to refer to specific years in chronicles along with
other dating techniques.

The cycle of correspondences between vruceletos and the days of the
week is repeated every 28 years, a period also used in old Russian
chronology as "solar cycle". The count of solar cycles in this
calendar system starts from March 1, 5508 BCE (called Constantinople
World Aera).

I.A.Klimishin in his book "Calendar and Chronology" (Moscow, Nauka,
1985, pp. 66-70) gives the following formulae to calculate solar
cycles and vruceletos ([] meaning the integer part of the quotient and
|| the remainder):

- First get the solar cycle (Q) of the year of Constantinople aera (B):

    Q = |B/28|

or Christian aera (R):

    Q = |(R-8)/28|

- Then calculate the vruceleto number (W) of the year:

    W = [Q/4] + |Q/7|

.', .', .', .i, .', .', .. corresponding to numbers 1-7 respectively.

In this module the same result is achieved with `solarcycle' and
`vruceleto' functions, the latter calling the former
internally. `vrutseleto' is an alias for `vruceleto'.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/D*

%changelog
