%define module_name Date-WeekOfYear
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Test/More.pm) perl(Time/Local.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.07
Release: alt1
Summary: Simple routine to return the ISO 8601 week of the year (as well as the ISO week year)
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/G/GN/GNG/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Date::WeekOfYear is small and efficient.  The only purpose is to return the
week of the year.  This can be called in either a scalar or list context.

In a scalar context, just the week number is returned (the year starts at week 1).

In a list context, both the week number and the year (YYYY) are returned.  This
ensures that you know which year the week number relates too.  This is only an
issue in the week where the year changes (ie depending on the day you can be in
either week 52, week 53 or week 1.

NOTE The year returned is not always the same as the Gregorian year for that day
for further details see ISO 8601.

To obtain the old functionality, a mode is also passed, WOY_OLD_MODE.  Note you
need to use the ':mode' or ':all' tags to use to gain access to WOY_OLD_MODE.

If mode WOY_ISO_MODE is used the output will be in the ISO 8601 format YYYY-Wxx
where YYYY is the year and xx is the two digit week number and 'W' denotes week.


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/D*

%changelog
