%define module_name DateTime-TimeZone-Catalog-Extend
%define _without_test 1
# BEGIN SourceDeps(oneline):
BuildRequires: perl(DateTime/TimeZone.pm) perl(DateTime/TimeZone/Alias.pm) perl(ExtUtils/MakeMaker.pm) perl(Test/More.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.3.3
Release: alt1
Summary: Extend DateTime::TimeZone catalog
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/J/JD/JDEGUEST/%{module_name}-v%{version}.tar.gz
BuildArch: noarch

%description
This is a very simple module based on the list of time zone aliases that are sometimes found in dates.

Upon using this module, it will add to the the DateTime::TimeZone::Catalog manpage those aliases with their corresponding time zone offset. When there is more than one time zone offset in the list, only the first one is set.

Here is the list of those time zone aliases and their offset:

=over 4

=item 1. `ACDT' +10:30 (Australian Central Daylight Saving Time)

=item 2. `ACST' +09:30 (Australian Central Standard Time)

=item 3. `ACT' +08:00 (ASEAN Common Time (proposed))

=item 4. `ACWST' +08:45 (Australian Central Western Standard Time (unofficial))

=item 5. `ADT' -03:00 (Atlantic Daylight Time)

=item 6. `AEDT' +11:00 (Australian Eastern Daylight Saving Time)

=item 7. `AEST' +10:00 (Australian Eastern Standard Time)

=item 8. `AET' +10:00 (Australian Eastern Time)

=item 9. `AFT' +04:30 (Afghanistan Time)

=item 10. `AKDT' -08:00 (Alaska Daylight Time)

=item 11. `AKST' -09:00 (Alaska Standard Time)

=item 12. `ALMT' +06:00 (Alma-Ata Time[1])

=item 13. `AMST' -03:00 (Amazon Summer Time (Brazil)[2])

=item 14. `AMT' +04:00 (Armenia Time)

=item 15. `ANAT' +12:00 (Anadyr Time[4])

=item 16. `AQTT' +05:00 (Aqtobe Time[5])

=item 17. `ART' -03:00 (Argentina Time)

=item 18. `AST' -04:00 (Atlantic Standard Time)

=item 19. `AWST' +08:00 (Australian Western Standard Time)

=item 20. `AZOST' UTC (Azores Summer Time)

=item 21. `AZOT' -01:00 (Azores Standard Time)

=item 22. `AZT' +04:00 (Azerbaijan Time)

=item 23. `BIOT' +06:00 (British Indian Ocean Time)

=item 24. `BIT' -12:00 (Baker Island Time)

=item 25. `BNT' +08:00 (Brunei Time)

=item 26. `BOT' -04:00 (Bolivia Time)

=item 27. `BRST' -02:00 (Brasadlia Summer Time)

=item 28. `BRT' -03:00 (Brasadlia Time)

=item 29. `BST' +01:00 (British Summer Time (British Standard Time from Feb 1968 to Oct 1971))

=item 30. `BTT' +06:00 (Bhutan Time)

=item 31. `CAT' +02:00 (Central Africa Time)

=item 32. `CCT' +06:30 (Cocos Islands Time)

=item 33. `CDT' -04:...

%prep
%setup -q -n %{module_name}-v%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc CONTRIBUTING.md README LICENSE CHANGES README.md
%perl_vendor_privlib/D*

%changelog
