Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(DateTime/Format/DateManip.pm) perl(YAML.pm) perl-podlators
# END SourceDeps(oneline)
# fedora bcond_with macro
%define bcond_with() %{expand:%%{?_with_%{1}:%%global with_%{1} 1}}
%define bcond_without() %{expand:%%{!?_without_%{1}:%%global with_%{1} 1}}
# redefine altlinux specific with and without
%define with()         %{expand:%%{?with_%{1}:1}%%{!?with_%{1}:0}}
%define without()      %{expand:%%{?with_%{1}:0}%%{!?with_%{1}:1}}
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# Add a support for Date::Manip time objects
%bcond_without perl_DateTimeX_Easy_enables_Date_Manip
# Add a support for ICal time format
%bcond_without perl_DateTimeX_Easy_enables_ical

Name:       perl-DateTimeX-Easy
Version:    0.091
Release:    alt1_5
# lib/DateTimeX/Easy.pm:            GPL-1.0-or-later OR Artistic-1.0-Perl
# LICENSE:                          GPL-1.0-or-later OR Artistic-1.0-Perl
# README:                           GPL-1.0-or-later OR Artistic-1.0-Perl
License:    GPL-1.0-or-later OR Artistic-1.0-Perl
Summary:    Parse a date/time string using the best method available
Source:     https://cpan.metacpan.org/authors/id/J/JJ/JJNAPIORK/DateTimeX-Easy-%{version}.tar.gz
Url:        https://metacpan.org/release/DateTimeX-Easy
BuildArch:  noarch
BuildRequires:  coreutils
BuildRequires:  rpm-build-perl
BuildRequires:  perl-devel
BuildRequires:  perl(Config.pm)
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(warnings.pm)
# Run-time:
BuildRequires:  perl(base.pm)
BuildRequires:  perl(Carp.pm)
BuildRequires:  perl(constant.pm)
BuildRequires:  perl(Date/Parse.pm)
BuildRequires:  perl(DateTime.pm)
BuildRequires:  perl(DateTime/Format/Flexible.pm)
BuildRequires:  perl(DateTime/Format/Natural.pm)
BuildRequires:  perl(DateTime/TimeZone.pm)
BuildRequires:  perl(Exporter.pm)
BuildRequires:  perl(Scalar/Util.pm)
BuildRequires:  perl(Time/Zone.pm)
BuildRequires:  perl(vars.pm)
# YAML not used, CPAN RT#144022
# Optional run-time:
# DateTime::Format::DateManip has been made optional due to instability
%if %{with perl_DateTimeX_Easy_enables_ical}
BuildRequires:  perl(DateTime/Format/ICal.pm)
%endif
# Tests:
BuildRequires:  perl(Test/More.pm)
BuildRequires:  perl(Test/Most.pm)
%if %{with perl_DateTimeX_Easy_enables_Date_Manip}
Requires:       perl(DateTime/Format/DateManip.pm)
%endif
%if %{with perl_DateTimeX_Easy_enables_ical}
Requires:     perl(DateTime/Format/ICal.pm)
%endif

# Do not export dependency on private module

Source44: import.info
%filter_from_requires /^perl(DateTimeX.Easy.DateParse.pm)/d

%description
DateTimeX::Easy makes DateTime object creation quick and easy. It uses a
variety of DateTime::Format packages to do the bulk of the parsing, with
some custom tweaks to smooth out the rough edges (mainly concerning
timezone detection and selection).

%package tests
Group: Development/Other
Summary:        Tests for %{name}
Requires:       %{name} = %{?epoch:%{epoch}:}%{version}-%{release}

%description tests
Tests from %{name}. Execute them
with "%{_libexecdir}/%{name}/test".

%prep
%setup -q -n DateTimeX-Easy-%{version}

# Help generators to recognize Perl scripts
for F in t/*.t; do
    perl -i -MConfig -ple 'print $Config{startperl} if $. == 1 && !s{\A#!\s*perl}{$Config{startperl}}' "$F"
    chmod +x "$F"
done

%build
perl Makefile.PL INSTALLDIRS=vendor NO_PACKLIST=1 NO_PERLLOCAL=1
%{make_build}

%install
%{makeinstall_std}
# %{_fixperms} %{buildroot}/*
# Install tests
mkdir -p %{buildroot}%{_libexecdir}/%{name}
cp -a t %{buildroot}%{_libexecdir}/%{name}
cat > %{buildroot}%{_libexecdir}/%{name}/test << 'EOF'
#!/bin/sh
cd %{_libexecdir}/%{name} && exec prove -I . -j "$(getconf _NPROCESSORS_ONLN)"
EOF
chmod +x %{buildroot}%{_libexecdir}/%{name}/test

%check
export HARNESS_OPTIONS=j$(perl -e 'if ($ARGV[0] =~ /.*-j([0-9][0-9]*).*/) {print $1} else {print 1}' -- '%{?_smp_mflags}')
make test

%files
%doc --no-dereference LICENSE
%doc Changes CONTRIBUTORS README
%dir %{perl_vendor_privlib}/DateTimeX
%{perl_vendor_privlib}/DateTimeX/Easy
%{perl_vendor_privlib}/DateTimeX/Easy.pm

%files tests
%{_libexecdir}/%{name}

%changelog
